<!DOCTYPE html>
<html lang="en">
	<head>
		<?php 
			include "includes/operations.php";
			include "includes/headerlinks.php";
			
			$result = mysqli_query($con, "SELECT * FROM banner");
			$row = mysqli_fetch_array($result);
			$banner_first_image = $row['banner_first_image'];
		?>
		<style>
			.hero__slider--bg {
				background-image:url('images/banner_images/<?php echo $banner_first_image; ?>'), url('images/banner_images/by-deafult.png') !important;
				background: url(../images/home1-slider1.webp);
				background-repeat: no-repeat;
				background-attachment: scroll;
				background-position: center center;
				background-size: cover;
			}
		</style>
	</head>
	<body>
		<?php 
			include "includes/top_header.php";
			include "includes/navigation.php";
			include "includes/mobile_navigation.php";
			include "includes/mobile_sticky_menus.php";
			include "includes/cart_window.php";
			include "includes/search.php";
		?>
		<main class="main__content_wrapper">
			<!-- Start slider section -->
			<?php include "includes/slider.php";?>
			<!-- End slider section -->

			<!-- Start product section -->
			<section class="product__section section--padding">
				<div class="container-fluid">
					<div class="section__heading text-center mb-30">
						<h2 class="section__heading--maintitle">Exclusive Products</h2>
						<hr class="hr-line">
					</div>
					<div class="col-12">
						<div class="shop__product--wrapper">
							<div class="tab_content">
								<div id="product_grid" class="tab_pane active show">
									<div class="product__section--inner product__grid--inner">
										<div class="row row-cols-xl-3 row-cols-lg-3 row-cols-md-3 row-cols-2 mb--n30">
											<?php 
												$product_image = '';
												$get_products = mysqli_query($con,"select * from product WHERE status=1");
												while($prod_row = mysqli_fetch_array($get_products)){
													$product_image = $prod_row['product_image'];
											?>
											<div class="col mb-30">
												<div class="product__items ">
													<div class="product__items--thumbnail">
														<a class="product__items--link" href="product-details.php?id=<?php echo $prod_row['product_id']?>">
															<img class="product__items--img product__primary--img custom-size" src="images/product_images/<?php echo $prod_row['product_image'];?>" alt="product-img">
															<img class="product__items--img product__secondary--img custom-size" src="images/product_images/<?php echo $prod_row['product_image'];?>" alt="product-img">
														</a>
														<ul class="product__items--action d-flex justify-content-center">
															<li class="product__items--action__list">
																<a class="product__items--action__btn quick_view" data-open="modal1" prod_id="<?php echo $prod_row['product_id'];?>" prod_title="<?php echo $prod_row['product_title'];?>" prod_desc="<?php echo $prod_row['product_description'];?>" prod_image="<?php echo $prod_row['product_image'];?>" prod_price="$<?php echo number_format($prod_row['product_price'],2);?>" href="javascript:void(0)">
																	<svg class="product__items--action__btn--svg" xmlns="http://www.w3.org/2000/svg" width="20.51" height="19.443" viewBox="0 0 512 512"><path d="M255.66 112c-77.94 0-157.89 45.11-220.83 135.33a16 16 0 00-.27 17.77C82.92 340.8 161.8 400 255.66 400c92.84 0 173.34-59.38 221.79-135.25a16.14 16.14 0 000-17.47C428.89 172.28 347.8 112 255.66 112z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32"></path><circle cx="256" cy="256" r="80" fill="none" stroke="currentColor" stroke-miterlimit="10" stroke-width="32"></circle></svg>
																	<span class="visually-hidden">Quick View</span>
																</a>
															</li>
														</ul>
													</div>
													<div class="product__items--content text-center">
														<h3 class="product__items--content__title h4"><a href="product-details.php?id=<?php echo $prod_row['product_id']?>"><?php echo $prod_row['product_title'];?></a></h3>
														<div class="product__items--price">
															<span class="current__price">$<?php echo number_format($prod_row['product_price'],2);?></span>
															
														</div>
														<a class="product__list--action__cart--btn primary__btn" id="btn_<?php echo $prod_row['product_id'];?>" onclick="add_cart(<?php echo $prod_row['product_id']; ?>,1,<?php echo $prod_row['product_id'];?>)" href="javascript:void(0)">
															 <svg class="product__list--action__cart--btn__icon" xmlns="http://www.w3.org/2000/svg" width="16.897" height="17.565" viewBox="0 0 18.897 21.565">
															  <path
															   d="M16.84,8.082V6.091a4.725,4.725,0,1,0-9.449,0v4.725a.675.675,0,0,0,1.35,0V9.432h5.4V8.082h-5.4V6.091a3.375,3.375,0,0,1,6.75,0v4.691a.675.675,0,1,0,1.35,0V9.433h3.374V21.581H4.017V9.432H6.041V8.082H2.667V21.641a1.289,1.289,0,0,0,1.289,1.29h16.32a1.289,1.289,0,0,0,1.289-1.29V8.082Z"
															   transform="translate(-2.667 -1.366)"
															   fill="currentColor"
															  ></path>
															 </svg>
															 <span class="product__list--action__cart--text cart_btn"> Add To Cart</span>
														</a>
													</div>
												</div>
											</div>
											<?php }?>
										</div>
									</div>
								</div>
							</div>
							<div class="pagination__area bg__gray--color" style="display:none">
								<nav class="pagination">
									<ul class="pagination__wrapper d-flex align-items-center justify-content-center">
										<li class="pagination__list"><a href="#" class="pagination__item--arrow  link ">
										<svg xmlns="http://www.w3.org/2000/svg" width="22.51" height="20.443" viewBox="0 0 512 512"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="48" d="M244 400L100 256l144-144M120 256h292"></path></svg></a>
										</li>
										<li>
										</li>
										<li class="pagination__list"><span class="pagination__item pagination__item--current">1</span></li>
										<li class="pagination__list"><a href="#" class="pagination__item link">2</a></li>
										<li class="pagination__list"><a href="#" class="pagination__item link">3</a></li>
										<li class="pagination__list"><a href="#" class="pagination__item link">4</a></li>
										<li class="pagination__list">
										<a href="#" class="pagination__item--arrow  link ">
											<svg xmlns="http://www.w3.org/2000/svg" width="22.51" height="20.443" viewBox="0 0 512 512"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="48" d="M268 112l144 144-144 144M392 256H100"></path></svg>
										</a>
										</li>
										<li>
										</li>
									</ul>
								</nav>
							</div>
						</div>
					</div>
				</div>
			</section>

		</main>

		<!-- Start footer section -->
		<?php include "includes/footer.php";?>
		<!-- End footer section -->

		<!-- Quickview Wrapper -->
		<div class="modal" id="modal1" data-animation="slideInUp">
			<div class="modal-dialog quickview__main--wrapper">
			   <header class="modal-header quickview__header">
					<button class="close-modal quickview__close--btn" aria-label="close modal" data-close="">✕ </button>
				</header>
			   <div class="quickview__inner">
					<div class="row row-cols-lg-2 row-cols-md-2">
						<div class="col">
							<div class="product__details--media">
								<div class="product__media--preview  swiper">
									<div class="swiper-wrapper">
										<div class="swiper-slide">
											<div class="product__media--preview__items">
												<a class="product__media--preview__items--link glightbox" data-gallery="product-media-preview" id="prod_image" href=""><img class="product__media--preview__items--img" src="" alt="product-media-img"></a>
												<div class="product__media--view__icon" style="display:none !important">
													<a class="product__media--view__icon--link glightbox" href="images/product_images/<?php echo $product_image;?>" data-gallery="product-media-preview">
														<svg class="product__media--view__icon--svg" xmlns="http://www.w3.org/2000/svg" width="22.51" height="22.443" viewBox="0 0 512 512"><path d="M221.09 64a157.09 157.09 0 10157.09 157.09A157.1 157.1 0 00221.09 64z" fill="none" stroke="currentColor" stroke-miterlimit="10" stroke-width="32"></path><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-miterlimit="10" stroke-width="32" d="M338.29 338.29L448 448"></path></svg>
														<span class="visually-hidden">Media Gallery</span>
													</a>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="product__media--nav swiper">
									<div class="swiper__nav--btn swiper-button-next"></div>
									<div class="swiper__nav--btn swiper-button-prev"></div>
								</div>
							</div>
						</div>
						<div class="col">
							<div class="quickview__info">
								<form action="#">
									<h2 class="product__details--info__title mb-15" id="prod_title"></h2>
									<div class="product__details--info__price mb-12">
										<span class="current__price" id="prod_price"></span>
									</div>
									<p class="product__details--info__desc mb-15" id="prod_desc"></p>
									<div class="product__variant">
										<div class="quickview__variant--list quantity d-flex align-items-center mb-15">
											<div class="quantity__box">
												<button type="button" class="quantity__value quickview__value--quantity decrease" aria-label="quantity value" value="Decrease Value">-</button>
												<label>
													<input type="hidden" id="prod_id" />
													<input type="number" class="quantity__number quickview__value--number" id="prod_quantity" value="1">
												</label>
												<button type="button" class="quantity__value quickview__value--quantity increase" aria-label="quantity value" value="Increase Value">+</button>
											</div>
											<button class="primary__btn quickview__cart--btn" id="modal_cart_btn" onclick="add_cart()" type="button" style="margin-left:0px !important;">Add To Cart</button>  
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Quickview Wrapper End -->
	<?php include "includes/footerlinks.php";?>
	<?php include "includes/cart_functions.php";?>
	</body>
</html>