<?php session_start(); ?>
<?php 
	include "database.php";
	if(!isset($_SESSION['admin_id'])){
		echo '<script> window.location.href = "login.php"; </script>';
		header("location:login.php"); exit();
	}
	
	$role = $_SESSION['role'];
	
	$user_id = $_SESSION['admin_id'];
?>
<!DOCTYPE html>
<html lang="en">

<head>
   <?php include "includes/headerlinks.php";?>
</head>

<body class="fix-header fix-sidebar card-no-border">
    <!-- ============================================================== -->
    <!-- Preloader - style you can find in spinners.css -->
    <!-- ============================================================== -->
    <?php include "includes/loader.php";?>
    <!-- ============================================================== -->
    <!-- Main wrapper - style you can find in pages.scss -->
    <!-- ============================================================== -->
    <div id="main-wrapper">
        <!-- ============================================================== -->
        <!-- Topbar header - style you can find in pages.scss -->
        <!-- ============================================================== -->
	<?php include "includes/header.php";?>
        <!-- ============================================================== -->
        <!-- End Topbar header -->
        <!-- ============================================================== -->
        <!-- ============================================================== -->
        <!-- Left Sidebar - style you can find in sidebar.scss  -->
        <!-- ============================================================== -->
		<?php include "includes/sidebar.php";?>
        <!-- ============================================================== -->
        <!-- End Left Sidebar - style you can find in sidebar.scss  -->
        <!-- ============================================================== -->
        <!-- ============================================================== -->
        <!-- Page wrapper  -->
        <!-- ============================================================== -->
		<div class="page-wrapper">
            <!-- ============================================================== -->
            <!-- Bread crumb and right sidebar toggle -->
            <!-- ============================================================== -->
            <div class="row page-titles">
                <div class="col-md-5 align-self-center">
                    <h3 class="text-themecolor">Completed Orders</h3>
                </div>
            </div>
            <!-- ============================================================== -->
            <!-- End Bread crumb and right sidebar toggle -->
            <!-- ============================================================== -->
            <!-- ============================================================== -->
            <!-- Container fluid  -->
            <!-- ============================================================== -->
            <div class="container">
			
			<?php if($role=='Super Admin'){?>
				<div class="card">
					<div class="card-body">
						<?php 
							$result = mysqli_query($con,"SELECT * FROM orders WHERE order_complete=1 ORDER BY id DESC");
							if(mysqli_num_rows($result)>0){
						?>
						<div class="table-responsive">
							<table class="table table-hover earning-box">
								<thead>
									<tr>
										<th>Order ID</th>
										<th>Customer</th>
										<th>Order Price</th>
										<th>Created At</th>
										<th>Details</th>
									</tr>
								</thead>
								<tbody>
									<?php
										while($row=mysqli_fetch_array($result)){
									?>
									<tr>
										<td>
											<?=$row['order_id']?><br>
											<span class="label label-warning"><i class="fa fa-check"></i> Completed</span>
										</td>
										<td>
											<h6><?=$row['customer_name']?></h6><small class="text-black"><?=$row['customer_email']?></small><br><small class="text-black"><?=$row['customer_phone']?></small>
										</td>
										<td><span class="label label-success">$<?php echo number_format($row['total_price'],2);?></span></td>
										<td><?php echo date("M-d-Y", strtotime($row['order_date']));?></td>
										<td>
											<a href="order_details.php?oid=<?php echo $row['id']?>"><button class="btn btn-sm btn-success">View Details</button></a>
										</td>
									</tr>
									<?php
											}
										
										
									?>
								</tbody>
							</table>
						</div>
						<?php
							} else {
											echo '<h3>No Record Found!</h3>';
										}
						?>
					</div>
				</div>

			<?php } ?>				
            </div> 
			
			<?php include "includes/footer.php";?>
        </div>
        <!-- ============================================================== -->
        <!-- End Page wrapper  -->
        <!-- ============================================================== -->
    </div>
    <!-- ============================================================== -->
    <!-- End Wrapper -->
    <!-- ============================================================== -->
    <!-- ============================================================== -->
    <!-- All Jquery -->
    <!-- ============================================================== -->
    <?php include "includes/footerlinks.php";?>
</body>

</html>