<?php session_start(); ?>
<?php 
	include "database.php";
	include "includes/operations.php";
	if(!isset($_SESSION['admin_id'])){
		echo '<script> window.location.href = "login.php"; </script>';
		header("location:login.php"); exit();
	}
	
	$admin_id = $_SESSION['admin_id'];
	
	function CheckAccess() {
		
    $result = (isset($_SESSION['role']) &&  $_SESSION['role'] != 'Super Admin');
		return $result;
	}
	
	if (CheckAccess()) {
		header("location:login.php");
			echo '<script> window.location.href = "login.php"; </script>';
			exit();
	}
	
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?php include "includes/headerlinks.php";?>
	<style>
		b {
			font-weight:600 !important;
		}
	</style>
</head>

<body class="fix-header card-no-border">
    <!-- ============================================================== -->
    <!-- Preloader - style you can find in spinners.css -->
    <!-- ============================================================== -->
    <?php include "includes/loader.php";?>
    <!-- ============================================================== -->
    <!-- Main wrapper - style you can find in pages.scss -->
    <!-- ============================================================== -->
    <div id="main-wrapper">
        <!-- ============================================================== -->
        <!-- Topbar header - style you can find in pages.scss -->
        <!-- ============================================================== -->
        <?php include "includes/header.php";?>
        <!-- ============================================================== -->
        <!-- End Topbar header -->
        <!-- ============================================================== -->
        <!-- ============================================================== -->
        <!-- Left Sidebar - style you can find in sidebar.scss  -->
        <!-- ============================================================== -->
        <?php include "includes/sidebar.php";?>
        <!-- ============================================================== -->
        <!-- End Left Sidebar - style you can find in sidebar.scss  -->
        <!-- ============================================================== -->
        <!-- ============================================================== -->
        <!-- Page wrapper  -->
        <!-- ============================================================== -->
        <div class="page-wrapper">
            <!-- ============================================================== -->
            <!-- Bread crumb and right sidebar toggle -->
            <!-- ============================================================== -->
            <div class="row page-titles">
                <div class="col-md-5 align-self-center">
                    <h3 class="text-themecolor">Manage IOT Devices</h3>
                </div>
                <div>
                    <button class="right-side-toggle waves-effect waves-light btn-inverse btn btn-circle btn-sm pull-right m-l-10"><i class="ti-settings text-white"></i></button>
                </div>
            </div>
            <!-- ============================================================== -->
            <!-- End Bread crumb and right sidebar toggle -->
            <!-- ============================================================== -->
            <!-- ============================================================== -->
            <!-- Container fluid  -->
            <!-- ============================================================== -->
            <div class="container-fluid">
                <!-- ============================================================== -->
                <!-- Start Page Content -->
                <!-- ============================================================== -->
                <!-- Row -->
				<div class="card">
                            <div class="card-body">
                                <h6 class="card-subtitle"><a href="#" class="btn btn-success btn-sm" data-toggle="modal" data-target="#addCategory">+ Add Device</a></h3></h6>
								
							<div aria-hidden="true" aria-labelledby="myModalLabel" role="dialog" tabindex="-1" id="addCategory" class="modal fade">
							<div class="modal-dialog">
								<div class="modal-content">
									<div class="modal-header">
										<h4 class="modal-title"><b>Add Device</b></h4>
										<button aria-hidden="true" data-dismiss="modal" class="close" type="button">×</button>
									</div>
									<div class="modal-body">
										<form method="post">
											<div class="form-group">
												<label for="exampleInputEmail1"><b>Name</b></label>
												<input type="text" class="form-control" name="category_name" id="exampleInputEmail3" placeholder="Enter Name.." required>
											</div>
											<div class="modal-footer">
												<button type="submit" name="add_category" class="btn btn-success">Save</button>
												<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
											</div>
										</form>
									</div>
								</div>
							</div>
						</div>
							
                                <div class="table-responsive m-t-40">
                                    <table id="myTable" class="table table-bordered table-striped">
                                        <thead>
										  <tr>
											<th>ID</th>
											<th>Device Name</th>
											<th>Edit</th>
											<th>Delete</th>
										  </tr>
										</thead>
                                        <tbody>
											<?php
												$count = 0;
												$result = mysqli_query($con,"SELECT * FROM category order by c_name ASC");
												while($row=mysqli_fetch_array($result)){
													$count++;
											?>
                                            <tr>
                                                <td><?php echo $count; ?></td>
                                                <td><?php echo $row['c_name']; ?></td>
                                                <td><a data-toggle="modal" data-target="#edit<?=$row['c_id'];?>"><button class="btn btn-sm btn-primary"><i class="fa fa-edit"></i></button></a></td>
												
												<div aria-hidden="true" aria-labelledby="myModalLabel" role="dialog" tabindex="-1" id="edit<?=$row['c_id'];?>" class="modal fade">
													<div class="modal-dialog">
														<div class="modal-content">
															<div class="modal-header">
																<h4 class="modal-title"><b>Edit Device</b></h4>
																<button aria-hidden="true" data-dismiss="modal" class="close" type="button">×</button>
															</div>
															<div class="modal-body">
																<form method="post">
																	<div class="form-group">
																		<label for="exampleInputEmail1"><b>Name</b></label>
																		<input type="hidden" name="category_id" value="<?=$row['c_id']?>">
																		<input type="text" class="form-control" name="c_name" value="<?php echo $row['c_name']?>" id="exampleInputEmail3" placeholder="Enter Name">
																	</div>
																	<div class="modal-footer">
																		<button type="submit" name="update_category" class="btn btn-success">Save</button>
																		<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
																	</div>
																</form>
															</div>
														</div>
													</div>
												</div>
												
												<td><a data-toggle="modal" data-target="#delete<?=$row['c_id'];?>"><button class="btn btn-sm btn-danger"><i class="fa fa-trash-o"></i></button></a></td>
												
												<div class="modal fade in" id="delete<?=$row['c_id'];?>"  role="dialog" aria-hidden="true">
												<div class="modal-dialog" role="document">
														<div class="modal-content">
														  <div class="modal-body">
															<h4>Are you sure you want to delete this ?</h4>
														  </div>
														  <div class="modal-footer">
															<form method="post">
																<input type="hidden" name="category_id" value="<?=$row['c_id']?>">
																<button type="submit" class="btn btn-danger" name="delete_category" >Delete</button>
																<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
															</form>
														  </div>
														</div>
													  </div>
												</div>
                                            </tr>
											<?php
												}
											  ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
            <!-- ============================================================== -->
            <!-- End Container fluid  -->
            <!-- ============================================================== -->
            <!-- ============================================================== -->
            <!-- footer -->
            <!-- ============================================================== -->
            <?php include "includes/footer.php";?>
            <?php include "includes/theme.php";?>
            <!-- ============================================================== -->
            <!-- End footer -->
            <!-- ============================================================== -->
        </div>
		
        <!-- ============================================================== -->
        <!-- End Page wrapper  -->
        <!-- ============================================================== -->
    </div>
    <!-- ============================================================== -->
    <!-- End Wrapper -->
    <!-- ============================================================== -->
    <!-- ============================================================== -->
    <!-- All Jquery -->
    <!-- ============================================================== -->
	
    <script src="../assets/plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="../assets/plugins/bootstrap/js/popper.min.js"></script>

    <script src="../assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="js/jquery.slimscroll.js"></script>
    <!--Wave Effects -->
    <script src="js/waves.js"></script>
    <!--Menu sidebar -->
    <script src="js/sidebarmenu.js"></script>
    <!--stickey kit -->
    <script src="../assets/plugins/sticky-kit-master/dist/sticky-kit.min.js"></script>
    <script src="../assets/plugins/sparkline/jquery.sparkline.min.js"></script>
    <!--Custom JavaScript -->
    <script src="js/custom.min.js"></script>
    <!-- ============================================================== -->
    <!-- Style switcher -->
    <!-- ============================================================== -->
    <script src="../assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>
</body>
   <script src="../assets/plugins/datatables/jquery.dataTables.min.js"></script>
    <script>
    $(document).ready(function() {
        $('#myTable').DataTable();
        $(document).ready(function() {
            var table = $('#example').DataTable({
                "columnDefs": [{
                    "visible": false,
                    "targets": 2
                }],
                "order": [
                    [2, 'asc']
                ],
                "displayLength": 25,
                "drawCallback": function(settings) {
                    var api = this.api();
                    var rows = api.rows({
                        page: 'current'
                    }).nodes();
                    var last = null;
                    api.column(2, {
                        page: 'current'
                    }).data().each(function(group, i) {
                        if (last !== group) {
                            $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                            last = group;
                        }
                    });
                }
            });
            // Order by the grouping
            $('#example tbody').on('click', 'tr.group', function() {
                var currentOrder = table.order()[0];
                if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                    table.order([2, 'desc']).draw();
                } else {
                    table.order([2, 'asc']).draw();
                }
            });
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
</html>
